﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CS_iSMS_Receive_Multiple_API_Polling_Mode
{
    class iSMSParser
    {
        // When iSMS receives a sendmsg request, it sends back either the 
        // ID number of the SMS, or "Err: error code".
        // The SMS ID is used when querying the status of an message sent.
        // This function gets the ID number from the response sent. This function will send
        // a negative number if an error occurs. -1=Uknown error, -2=Error code retrieved.
        public int ParseID(String iSMSresponse)
        {
            if (iSMSresponse.Contains("ID: "))
            {
                String tempID = iSMSresponse.Remove(0, 4);
                int tINT = Convert.ToInt32(iSMSresponse.Remove(0, 4));
                return tINT;
            }
            if (iSMSresponse.Contains("Err: "))
            {
                return -2;
            }
            return -1;
        }

        // When iSMS receives a query, it response with a status: or err: message.
        // This function returns the status or error code. Status codes are 1-5, 
        // and error codes are 601-614.
        public int ParseStatusCode(String iSMSresponse)
        {
            if (iSMSresponse.Length < 3) return -1;

            if (iSMSresponse.Contains("Err:"))
            {   // Error codes are preceded by Err:
                int codeStart = iSMSresponse.IndexOf("Err:") + 5;
                int statusCode = Convert.ToInt32(iSMSresponse.Substring(codeStart, 3), 10);
                return statusCode;
            }
            if (iSMSresponse.Contains("Status:"))
            {   // Status code is preceded by Status:
                int codeStart = iSMSresponse.IndexOf("Status:") + 8;
                int statusCode = Convert.ToInt32(iSMSresponse.Substring(codeStart, 1), 10);
                return statusCode;
            }
            return -1;
        }

        // This function retrieves the error code from a iSMS response.
        public int ParseErrorCode(String iSMSresponse)
        {
            if (iSMSresponse.Contains("Err:"))
            {   // Error codes are preceded by Err:
                int codeStart = iSMSresponse.IndexOf("Err:") + 5;
                String tStr = iSMSresponse.Substring(codeStart, 3);
                int statusCode = Convert.ToInt32(tStr, 10);
                return statusCode;
            }
            return 0;
        }

        public int ParseCount(String iSMSresponse)
        {
            if (iSMSresponse.Contains("Count:"))
            {   // Error codes are preceded by Err:
                int countStart = iSMSresponse.IndexOf("Count:") + 6;
                String strCount = iSMSresponse.Substring(countStart);
                //System.Windows.Forms.MessageBox.Show("Response=" + iSMSresponse + ", strCount=" + strCount);
                int statusCode = Convert.ToInt32(strCount, 10);
                return statusCode;
            }
            return -1;
        }


        // This function gets the error code from a iSMS response and then
        // uses a switch command to return a description of that error.
        public String GetErrorDesc(String iSMSresponse)
        {   // Get error code from response
            int errorCode = ParseErrorCode(iSMSresponse);
            if (errorCode < 601) return "";
            switch (errorCode)
            {
                case 601:
                    return "Authentication Failed";
                case 602:
                    return "Parse Error";
                case 603:
                    return "Invalid Category";
                case 604:
                    return "SMS message size is greater than 160 chars";
                case 605:
                    return "Recipient Overflow";
                case 606:
                    return "Invalid Recipient";
                case 607:
                    return "No Recipient";
                case 608:
                    return "MultiModem iSMS is busy, can't accept this request";
                case 609:
                    return "Timeout waiting for a TCP API request";
                case 610:
                    return "Unknown Action Trigger";
                case 611:
                    return "Error in broadcast trigger";
                case 612:
                    return "System Error - Memory Allocation Failure";
                case 613:
                    return "Invalid modem index";
                case 614:
                    return "Invalid device model number";
                case 615:
                    return "Invalid Encoding type";
                case 616:
                    return "Invalid Time/Date Input";
                case 617:
                    return "Invalid Count Input";
                case 618:
                    return "Service Not Available";
                case 619:
                    return "Invalid Addressee";
                case 620:
                    return "Invalid Priority value";
                case 621:
                    return "Invalid SMS test";
                default:
                    return "Unknown Error " + errorCode.ToString();
            }
        }

        public String GetStatusDesc(String iSMSresponse)
        {
            // Use smsParser class to get status code from iSMS response.
            int statusCode = ParseStatusCode(iSMSresponse);
            // Use switch command to interpet statusCode
            switch (statusCode)
            {
                case 0: // done. Successfully sent
                    return "Status Code: 0 (Done), SMS was sent successfully.";
                case 1: // Done with errors
                    return "Status Code: 1 (Done with Error), SMS may not have been sent to all recipients.";
                case 2: // In process
                    return "Status Code: 2 (In progress).";
                case 3: // Received SMS
                    return "Status Code: 3 (Request received).";
                case 4: // Error
                    return "Status Code: 4 (Error), Error occured while sending the SMS.";
                case 5: // Message not found
                    return "Status Code: 5 (Message ID does not exist).";
                case 6: // Distributed to Slave
                    return "Status Code: 6 (Distributed to Slave).";
                case 7: // Distribution resulted in error
                    return "Status Code: 7 (Distribution resulted in error).";
                case 8: // Distributed among many slaves
                    return "Status Code: 8 (Distributed among many slaves).";
                case 9: // API is canceled
                    return "Status Code: 9 (API is canceled).";
                default: // Unknown status code
                    return "Status Code: ?, Unable to connect to SMS Finder.";
            }
        }
    }
}
